/**
 * AMI Task Planner — Memory-First task decomposition.
 *
 * Ported from ami_task_planner.py.
 *
 * Memory-First flow:
 * 1. Query Memory plan for the whole task → EXECUTION PLAN context
 * 2. Inject Memory context into LLM decomposition prompt
 * 3. Decompose into atomic, self-contained subtasks
 * (workflow_guide injection to subtasks is skipped — handled by L2 runtime)
 */
import { type AMISubtask } from "./schemas.js";
import type { SSEEmitter } from "../events/emitter.js";
import { type MemoryPlanData } from "../tools/memory-tools.js";
export declare class AMITaskPlanner {
    private taskId;
    private emitter?;
    private apiKey?;
    private memoryApiBaseUrl;
    private workerDescriptions;
    constructor(opts: {
        taskId: string;
        emitter?: SSEEmitter;
        apiKey?: string;
        memoryApiBaseUrl: string;
        workerDescriptions?: Record<string, string>;
    });
    decomposeAndQueryMemory(task: string): Promise<AMISubtask[]>;
    fineGrainedDecompose(task: string, memoryContext?: string): Promise<AMISubtask[]>;
    parseXmlSubtasks(responseText: string): AMISubtask[];
    private parseCoarseSubtasks;
    static inferAgentType(content: string): string;
    /**
     * Format MemoryPlanData as context string for the decomposition prompt.
     *
     * Each step is a concrete action with optional Memory backing
     * (workflow_guide with URLs, clicks, operations).
     *
     * Returns empty string if no useful data.
     */
    static formatMemoryPlanForDecompose(memoryPlan: MemoryPlanData): string;
    /**
     * Build a human-readable memory report for chat display.
     * Matches Python ami_task_planner.py _build_planner_agent_report().
     */
    static buildMemoryReport(memoryPlan: MemoryPlanData, level: string): string;
    private buildWorkersInfo;
    private emitDecomposeResult;
}
//# sourceMappingURL=task-planner.d.ts.map