/**
 * Orchestrator Session — persistent parent agent that manages user sessions.
 *
 * Ported from orchestrator_agent.py OrchestratorSession.
 *
 * Architecture:
 * - Persistent Agent with tools: shell_exec, search_google, ask_human,
 *   attach_file, decompose_task, inject_message, cancel_task, replan_task
 * - decompose_task triggers: TaskPlanner → TaskExecutor in background
 * - inject_message/cancel_task operate on running executors
 * - Main loop: process message → wait for user message or executor completion
 */
import type { AgentTool } from "@mariozechner/pi-agent-core";
import { type AgentType } from "../prompts/unified-agent.js";
import { type ExecutionResult } from "./schemas.js";
import type { SSEEmitter } from "../events/emitter.js";
import type { TaskState } from "../services/task-state.js";
export declare class OrchestratorSession {
    private taskId;
    readonly taskState: TaskState;
    private emitter;
    private apiKey?;
    private workspaceDir;
    private agent;
    private ctx;
    private executorCounter;
    private runningExecutors;
    private lastExecutionResult;
    private childAgentToolsFactory?;
    constructor(opts: {
        taskId: string;
        taskState: TaskState;
        emitter: SSEEmitter;
        apiKey?: string;
        workspaceDir?: string;
        childAgentToolsFactory?: (agentType: AgentType, sessionId: string, workingDirOverride?: string) => AgentTool<any>[];
    });
    run(initialMessage: string): Promise<ExecutionResult | null>;
    private createOrchestratorAgent;
    private supervisedExecute;
    private planAndExecute;
    private waitForEvent;
    private collectCompleted;
    private buildActiveTasksContext;
    /**
     * Reconstruct AMISubtask[] from persisted subtask snapshots.
     * DONE subtasks are preserved as-is (executor skips them since they're not PENDING).
     * FAILED and RUNNING subtasks are reset to PENDING for re-execution.
     */
    private buildResumeSubtasks;
    private extractLastAssistantText;
    private buildAttachments;
    pauseExecutors(): void;
    resumeExecutors(): void;
    private _cleanupDone;
    cleanup(): Promise<void>;
}
//# sourceMappingURL=orchestrator.d.ts.map