/**
 * Agent Factory — creates child agents using pi-agent-core.
 *
 * `createChildAgentTools` assembles the correct tool set per AgentType:
 * - browser: BrowserTools, FileTools, TerminalTools, SearchTools, HumanTools, MarkItDownTools, MemoryTools
 * - code: TerminalTools, FileTools, HumanTools, SearchTools
 * - document: FileTools, ExcelTools, PptxTools, MarkItDownTools, TerminalTools, HumanTools
 * - multi_modal: ImageTools, AudioTools, VideoTools, FileTools, TerminalTools, HumanTools
 */
import { Agent } from "@mariozechner/pi-agent-core";
import type { AgentTool } from "@mariozechner/pi-agent-core";
import type { SSEEmitter } from "../events/emitter.js";
import type { TaskState } from "../services/task-state.js";
import type { AgentType } from "../prompts/unified-agent.js";
/**
 * Assemble the correct tool set for a given agent type.
 * Mirrors Python agent_factories.py tool assembly.
 */
export declare function createChildAgentTools(agentType: AgentType, sessionId: string, opts: {
    workingDir: string;
    taskId: string;
    taskState: TaskState;
    apiKey?: string;
    emitter?: SSEEmitter;
}): AgentTool<any>[];
export declare function createChildAgent(apiKey: string | undefined, tools: AgentTool<any>[], systemPrompt: string): Agent;
export declare function executeTask(state: TaskState, apiKey?: string): Promise<void>;
//# sourceMappingURL=agent-factory.d.ts.map